-- The Buyan-class corvette was designed by Zelenodolsk Design and designated Project 21630 
--  by the Russian Government.
-- Author: Markindel

-----             Cartella Shapes --------------------------------------------------
mount_vfs_model_path	(current_mod_path.."/Shapes/")

-----             Cartella Textures ---------------------------------------------------
mount_vfs_texture_path  (current_mod_path.."/Textures/Buyan_Class_Corvette.zip")
mount_vfs_texture_path  (current_mod_path.."/Textures/Buyan_Color.zip")
mount_vfs_texture_path  (current_mod_path.."/Textures/")




GT = {};
GT_t.ws = 0;

set_recursive_metatable(GT, GT_t.generic_ship)

GT.visual = {}
GT.visual.shape = "Grad_Sviyazhsk"
GT.visual.shape_dstr = ""

GT.animation_arguments.radar1_rotation = 11; --   1
GT.radar1_period = 3;
GT.animation_arguments.radar2_rotation = -1; --   2 
GT.animation_arguments.radar3_rotation = -1; --   3 
GT.animation_arguments.luna_lights = -1;


GT.life = 2700;
GT.mass = 9.59e+006;
GT.max_velocity = 15.4333
GT.race_velocity = 15.4333
GT.economy_velocity = 10.2889
GT.economy_distance = 1.1112e+007
GT.race_distance = 2.778e+006
GT.shipLength = 172.8
GT.Width = 15
GT.Height = 37.2
GT.Length = 172.8
GT.DeckLevel = 8
GT.X_nose = 34
----GT.X_tail = -85.9824  Valore Originale
GT.X_tail = -33
GT.Tail_Width = 33
GT.Gamma_max = 0.35
GT.Om = 0.05
GT.speedup = 0.229734
GT.R_min = 345.6
GT.distFindObstacles = 568.4

--GT.numParking = 1
--GT.Plane_Num_ = 0
--GT.Helicopter_Num_ = 2

GT.airWeaponDist = 100000
GT.airFindDist = 150000


---- Primo valore    : avanti/indietro
---- Secondo valore: alto/basso
---- Terzo Valore    : destra/sinistra
-- GT.Landing_Point = {-44.0, 4.93, 0.0}  ---- Valori Originali
---GT.Landing_Point = {-62.0, 4.83, 0.0}

--[[
-------------- Descrizione Aree del sistema dei danni  TICONDEROGA
----- AREA SCAFO -------------------------------------------------------------------------
    { area_name = "NOSE_R",			area_arg = 70,	--- scafo - fiancata prua destra  		() - scafo prua dx
    { area_name = "BORT_R",			area_arg = 71,	--- scafo - fiancata centrale destra
    { area_name = "KORMA_R", 		area_arg = 72,	--- scafo - fiancata poppa destra		() - scafo poppa dx
    { area_name = "NOSE_L", 		area_arg = 73,	--- scafo - fiancata prua sinistra		() - scafo prua sx
    { area_name = "BORT_L", 		area_arg = 74,	--- scafo - fiancata centrale sinistra
    { area_name = "KORMA_L", 		area_arg = 75,	--- scafo - fiancata poppa sinistra		() - scafo poppa sx
---- Area Sovrastrutture	
	{ area_name = "NOSE_TOP",		area_arg = 76,	--- VLS di prua							() - lanciamissili a/a prua
    { area_name = "RUBKA_TOP",		area_arg = 77,	--- Traliccio antenna radar centrale	()
	{ area_name = "HP",				area_arg = 78,	--- Area appontaggio elicotteri di poppa () - ponte poppa
	{ area_name = "KORMA_BACK", 	area_arg = 79,	??
	{ area_name = "KABINA",			area_arg = 80,	--- Gruppo Sala Comando					() - Strutture prua cabina comando
	{ area_name = "BORT_TOP_Back", 	area_arg = 81,	--- VLS di poppa						() - VLS
	{ area_name = "NADSTROYKA",		area_arg = 82,	--- Sovrastrutture di poppa				() - strutture di poppa
	{ area_name = "SUPERSTRUCTURE_Mid",	area_arg = 83,	--- Sovrastrutture centrali 
	{ area_name = "KORMA_TOP", 		area_arg = 84,	---  ponte poppa						() - lanciamissili a/a poppa
    { area_name = "TOWER_NOSE",		area_arg = 97,	---  cannone di prua					() - cannone principale prua
	{ area_name = "TOWER_KORMA",	area_arg = 98,	---  cannone di poppa
    { area_name = "ZA_R",			area_arg = 99,	---  CIWS di destra						() -- Mgun Dx
    { area_name = "ZA_L",			area_arg = 100,	---  CIWS di poppa						() -- Mgum Sx 
--]]

GT.DM = {
---  Aree utilizzate nel mod
    { area_name = "NOSE_R",			area_arg = 70,	area_life = 110, area_fire = { pos = {14.0, 4.0, 3.5}, size = 0.8}},
    { area_name = "NOSE_L", 			area_arg = 73,	area_life = 110, area_fire = { pos = {14.0, 4.0, -3.5}, size = 0.8}},
    { area_name = "BORT_R",			area_arg = 71,	area_life = 110, area_fire = { pos = {0.0,  2.0, 3.5}, size = 0.8}},
    { area_name = "BORT_L", 			area_arg = 74,	area_life = 110, area_fire = { pos = {0.0,  2.0, -3.5}, size = 0.8}},
    { area_name = "KORMA_R", 		area_arg = 72,	area_life = 110, area_fire = { pos = {-14.0, 2.0, 5.7}, size = 0.8}},
    { area_name = "KORMA_L", 		area_arg = 75,	area_life = 110, area_fire = { pos = {-15.0, 2.0, -5.7}, size = 0.8}},
    { area_name = "BORT_TOP_Back", 	area_arg = 81,	area_life = 80,  area_fire = { pos = {-8.5, 7.0, 0.0}, size = 0.5}},
    { area_name = "ZA_R",			area_arg = 99,	area_life = 27, area_fire = { pos = {3.7, 17.15, 6.25}, size = 0.5}},
    { area_name = "ZA_L",			area_arg = 100,	area_life = 27, area_fire = { pos = {3.7, 17.15, -6.25}, size = 0.5}},
    { area_name = "NADSTROYKA",		area_arg = 82,	area_life = 220, area_fire = { pos = {-3.0, 12.0, 0.0}, size = 1.5}},
    { area_name = "SUPERSTRUCTURE_Mid",	area_arg = 83,	area_life = 320, area_fire = { pos = {-1.0, 8.0, 0.0}, size = 1.5}},
    { area_name = "TOWER_NOSE",		area_arg = 97,	area_life = 60, area_fire = { pos = {8.0, 9.0, 0.0}, size = 0.5}},
    { area_name = "TOWER_KORMA",	area_arg = 98,	area_life = 60, area_fire = { pos = {-7.5, 5.5, 0.0}, size = 0.5}},
    { area_name = "NOSE_TOP",		    area_arg = 76,	area_life = 80,  area_fire = { pos = {10.5, 7.5, 0.0}, size = 0.5}},
    { area_name = "KORMA_TOP", 		area_arg = 84,	area_life = 40, area_fire = { pos = {-8.5, 4.2, 0.0}, size = 1.0}},    
	{ area_name = "RUBKA_TOP",		area_arg = 77,	area_life = 100,  area_fire = { pos = {09.0, 13.0, 0.0}, size = 1.5}},
	{ area_name = "HP",				area_arg = 78,	area_life = 80,  area_fire = { pos = {-14.0, 9.6, 0.0}, size = 0.5}},
	{ area_name = "KORMA_BACK", 	area_arg = 79,	area_life = 110, area_fire = { pos = {-8.7, 2.0, 0.0}, size = 0.5}},
	{ area_name = "KABINA",			area_arg = 80,	area_life = 220, area_fire = { pos = {9.0, 8.0, 0.0}, size = 2.0}},
	{ area_name = "NADSTROYKA",		area_arg = 82,	area_life = 220, area_fire = { pos = {-3.0, 12.0, 0.0}, size = 1.5}},
	{ area_name = "SUPERSTRUCTURE_Mid",	area_arg = 83,	area_life = 320, area_fire = { pos = {6.0, 8.0, 0.0}, size = 1.5}},
 
}

-----------------------------------------------------------------------------------------------------------
-- weapon systems
-----------------------------------------------------------------------------------------------------------
GT.WS = {}
local ws;
GT.WS.maxTargetDetectionRange = 450000;
GT.WS.radar_type = 102
GT.WS.searchRadarMaxElevation = math.rad(60);

------------------------------------------------------------------------
--Vympel Center
------------------------------------------------------------------------1

ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.SS_t.VYMPEL_TRACKER[1]);
GT.WS[ws].center = 'CENTER_RADAR_04'
GT.WS[ws].angles[1][1] = math.rad(140);
GT.WS[ws].angles[1][2] = math.rad(-140);
GT.WS[ws].drawArgument1 = 6
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.SS_t.VYMPEL_TRACKER[2]);
GT.WS[ws].base = ws-1;
local vympel_trackers = {{{"self", ws-1}}, {{"self", ws}}};




----------------------------------------------------------------------------------------------------------------------------------------
--                    CIWS AK630
----------------------------------------------------------------------------------------------------------------------------------------
------------ Torretta Binata CIWS AK630 di Poppa

--  
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.phalanx )
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.AK630)
--GT.WS[ws].LN[1].depends_on_unit = vympel_trackers;
GT.WS[ws].area = 'NOSE_L'
GT.WS[ws].center = 'CENTER_TOWER_01'
GT.WS[ws].drawArgument1 = 35   ------ Right/Left 
GT.WS[ws].drawArgument2 = 36   ------ Down/Up
--GT.WS[ws].angles[1][1] = math.rad(-35);
--GT.WS[ws].angles[1][2] = math.rad(35);
GT.WS[ws].angles = { {math.rad(-35), math.rad(35), math.rad(-12), math.rad(88)}};
GT.WS[ws].reference_angle_Y = math.rad(-180);
GT.WS[ws].LN[1].BR[1].recoilTime = 0.2;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_AK630_1_1',
		recoilArgument = 119,
	},
	{
		connector_name = 'POINT_AK630_1_2',
		recoilArgument = 119,
	}
}


-- Nose Machineguns M2 .50cal ------ Poppa Sx
ws = GT_t.inc_ws();
GT.WS[ws] = {}
GT.WS[ws].center = 'CENTER_TOWER_02'
GT.WS[ws].drawArgument1 = 49
GT.WS[ws].drawArgument2 = 50
GT.WS[ws].angles = {
					{math.rad(-90), math.rad(45), math.rad(-5), math.rad(88)},
}
GT.WS[ws].reference_angle_Y = math.rad(-180);					
--__LN = add_launcher(GT.WS[ws], GT_t.LN_t.machinegun_12_7_M2);
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.automatic_gun_25mm);
__LN.BR[1].connector_name = 'POINT_GUN_02'
__LN.fireAnimationArgument = 125;

-- Nose Machineguns M2 .50cal ------ Prua Sx
ws = GT_t.inc_ws();
GT.WS[ws] = {}
GT.WS[ws].center = 'CENTER_TOWER_04'
GT.WS[ws].drawArgument1 = 51
GT.WS[ws].drawArgument2 = 52
GT.WS[ws].angles = {
					{math.rad(135), math.rad(0), math.rad(-5), math.rad(88)},
}
GT.WS[ws].reference_angle_Y = math.rad(90);					
--__LN = add_launcher(GT.WS[ws], GT_t.LN_t.machinegun_12_7_M2);
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.automatic_gun_25mm);
__LN.BR[1].connector_name = 'POINT_GUN_04'
__LN.fireAnimationArgument = 126;


-- Nose Machineguns M2 .50cal ------ Prua Dx
ws = GT_t.inc_ws();
GT.WS[ws] = {}
GT.WS[ws].center = 'CENTER_TOWER_05'
GT.WS[ws].drawArgument1 = 53
GT.WS[ws].drawArgument2 = 54
GT.WS[ws].angles = {
					{math.rad(-0), math.rad(-135), math.rad(-5), math.rad(88)},
}
GT.WS[ws].reference_angle_Y = math.rad(-90);					
--__LN = add_launcher(GT.WS[ws], GT_t.LN_t.machinegun_12_7_M2);
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.automatic_gun_25mm);
__LN.BR[1].connector_name = 'POINT_GUN_05'
__LN.fireAnimationArgument = 127;

-- Nose Machineguns M2 .50cal ------ Fiancata Dx
ws = GT_t.inc_ws();
GT.WS[ws] = {}
GT.WS[ws].center = 'CENTER_TOWER_06'
GT.WS[ws].drawArgument1 = 55
GT.WS[ws].drawArgument2 = 56
GT.WS[ws].angles = {
					{math.rad(180), math.rad(0), math.rad(-5), math.rad(88)},
}
GT.WS[ws].reference_angle_Y = math.rad(90);					
--__LN = add_launcher(GT.WS[ws], GT_t.LN_t.machinegun_12_7_M2);
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.automatic_gun_25mm);
__LN.BR[1].connector_name = 'POINT_GUN_06'
__LN.fireAnimationArgument = 128;


-- Nose Machineguns M2 .50cal ------ Fiancata Sx
ws = GT_t.inc_ws();
GT.WS[ws] = {}
GT.WS[ws].center = 'CENTER_TOWER_07'
GT.WS[ws].drawArgument1 = 57
GT.WS[ws].drawArgument2 = 58
GT.WS[ws].angles = {
					{math.rad(-0), math.rad(-180), math.rad(-5), math.rad(88)},
}
GT.WS[ws].reference_angle_Y = math.rad(-90);					
--__LN = add_launcher(GT.WS[ws], GT_t.LN_t.machinegun_12_7_M2);
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.automatic_gun_25mm);
__LN.BR[1].connector_name = 'POINT_GUN_07'
__LN.fireAnimationArgument = 129;


---------------------------------------------------------------------------------------------------------------------------------------------------------
--          TORRETTA DI PRUA
---------------------------------------------------------------------------------------------------------------------------------------------------------
-- Artillery Guns
--------------  Soobrazitelnyy: turret prow Arsenal A-190-01
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_FMC5 )
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.AK130);
GT.WS[ws].area = 'TOWER_NOSE'
GT.WS[ws].center = 'CENTER_TOWER_03'
GT.WS[ws].drawArgument1 = 0
GT.WS[ws].drawArgument2 = 1
GT.WS[ws].angles[1][1] = math.rad(160);
GT.WS[ws].angles[1][2] = math.rad(-160);
GT.WS[ws].LN[1].BR[1].connector_name = 'POINT_GUN_03'
GT.WS[ws].LN[1].BR[1].recoilArgument = 133;
GT.WS[ws].LN[1].BR[1].recoilTime = 0.2;

----------------------------------------------------------------------------------
-- 3M-54 Kalibr-NK
-----------------------------------------------------------------------------------
local KalibrNKW = {
	category		= CAT_MISSILES,
	name			= "KalibrNK",
	user_name	 	= _("KalibrNK"),
	wsTypeOfWeapon  = {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},
	Escort 			= 1, -- 0, 
						-- 0, 1 ou 3 ?? 
						-- 0 - N/A, 1 - LA start, 
						-- 2 - another LA, 
						-- 3 - land
						-- 0 tir et oubli -- 1 guide
	Head_Type 		= 2, -- 5 
						-- 5 ou 7 ? -- InfraredSeeker = 1 
						-- ActiveRadar = 2; 
						-- AntiRadar = 3; 
						-- LaserHoming = 4; 
						-- Autopilot = 5; 
						-- SemiActiveRadar = 6; 
						-- SemiAutoAT = 7;
						-- 5 tir et oubli 
						-- 7 malutka
	sigma 			= {4, 4, 4}, -- the maximum error of sight in meters, the target coordinates. X Y Z
	M 				= 23.5,
	H_max 			= 250.0, -- Max Altitude
	H_min 			= 25, -- Min Altitude
	Diam 			= 760.0,
	Cx_pil 			= 2.0,
	D_max 			= 80000.0, 
	D_min 			= 8000.0,
	Head_Form 		= 1, -- 0 - hemispherical shape of the head, 1 - ogival 
	Life_Time 		= 600.0,
	Nr_max 			= 0.5, -- MAx G turn rate
	v_min 			= 170.0,
	v_mid 			= 200.0,
	Mach_max 		= 0.9,
	t_b 			= 0.0,
	t_acc 			= 5.0,
	t_marsh 		= 0.0,
	Range_max 		= 90000.0,
	H_min_t 		= 0.0,
	Fi_start 		= 1.0, -- tracking and viewing angle at start (rad)
	Fi_rak 			= 3.14152, -- max angle of target (rad)
	Fi_excort 		= 1.05, -- max angle missile vs target (rad)
	Fi_search 		= 99.9, -- max search angle (rad)
	OmViz_max 		= 99.9, -- max speed for target visibility 

	warhead 		= 
	{
		mass 					= 2573; 
		expl_mass 				= 513; 
		other_factors 			= {1, 1, 1};
		obj_factors 			= {1, 1};
		concrete_factors 		= {1, 1, 1};
		cumulative_factor 		= 3.0;
		concrete_obj_factor 	= 0.0;
		cumulative_thickness 	= 0.9;
		piercing_mass			= 0.0;
		caliber					= 150,
	},
---- Primo valore    : avanti/indietro
---- Secondo valore: alto/basso
---- Terzo Valore    : destra/sinistra
	Damage 			= 50, 
--	exhaust 		= {0.9, 0.9, 0.85, 0.3},  -- Tail smoke color format {R, G, B, alpha}. All values from 0 to 1
	exhaust 		= {0.0, 0.0, 0.0, 0.0},  -- Tail smoke color format {R, G, B, alpha}. All values from 0 to 1
---	X_back 			= -0.8, -- exhaust X
	X_back 			= 0.0, -- exhaust X
	Y_back 			= 0.0,  -- exhaust Y
--	Y_back 			= 3.0,  -- exhaust Y
	Z_back 			= 0.0,  -- exhaust Z
	Reflection 		= 0.015, -- radar reflection cross
	KillDistance 	= 0.0, -- this distance is used to fire a fuze // type 428 proximity fuze
	shape_table_data = 
	{
		{
			name	 = "KalibrNK";
			file  	 = "KalibrNKM";
			life  	 = 1;
			fire  	 = { 0, 1};
			username = "KalibrNK";
			index = WSTYPE_PLACEHOLDER;
		},
	}
}
declare_weapon(KalibrNKW)
	
GT_t.WS_t.ship_KalibrNKW = {} 
GT_t.WS_t.ship_KalibrNKW.angles = {
					{math.rad(45), math.rad(-45), math.rad(-10), math.rad(45)},
					};
GT_t.WS_t.ship_KalibrNKW.reference_angle_Z = math.rad(60);
GT_t.WS_t.ship_KalibrNKW.moveable = false
GT_t.WS_t.ship_KalibrNKW.LN = {}
GT_t.WS_t.ship_KalibrNKW.LN[1] = {}
GT_t.WS_t.ship_KalibrNKW.LN[1].type = 1
GT_t.WS_t.ship_KalibrNKW.LN[1].distanceMin = 8000
GT_t.WS_t.ship_KalibrNKW.LN[1].distanceMax = 80000
GT_t.WS_t.ship_KalibrNKW.LN[1].reactionTime = 10; -- Preload time 240s.
GT_t.WS_t.ship_KalibrNKW.LN[1].launch_delay = 5;
GT_t.WS_t.ship_KalibrNKW.LN[1].sound = { single_shot = "Weapons/MissileLaunch2", }
GT_t.WS_t.ship_KalibrNKW.LN[1].external_tracking_awacs = true
GT_t.WS_t.ship_KalibrNKW.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_KalibrNKW.LN[1].sensor, GT_t.WSN_t[0])
GT_t.WS_t.ship_KalibrNKW.LN[1].PL = {}
GT_t.WS_t.ship_KalibrNKW.LN[1].PL[1] = {}
GT_t.WS_t.ship_KalibrNKW.LN[1].PL[1].ammo_capacity = 4
GT_t.WS_t.ship_KalibrNKW.LN[1].PL[1].type_ammunition = {4,4,11,121}
--GT_t.WS_t.ship_KalibrNKW.LN[1].PL[1].name_ammunition = "P_15"
GT_t.WS_t.ship_KalibrNKW.LN[1].PL[1].name_ammunition = "P-15M"
GT_t.WS_t.ship_KalibrNKW.LN[1].PL[1].reload_time = 1000000; -- never during the mission
GT_t.WS_t.ship_KalibrNKW.LN[1].BR = { {pos = {0, 0, 0} } }
----RBS15 Launchers  


---------------   Sistema Missilistico VLS -------------------------------------------------
--
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_MK41_SM2 )
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_TOMAHAWK )
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_granit)   ---  missile anti nave - troppo grosso
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_rifM)     ---  missile anti aereo
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_bazalt)   ---  Missile anti nave - troppo grosso
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_HARPOON )


ws = GT_t.inc_ws();
GT.WS[ws] = {}
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Kalibr-NKW)   -----  VLS
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_HARPOON )
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_KalibrNKW)
GT.WS[ws].animation_alarm_state = {time = 1.5, arg = 153} 
GT.WS[ws].area = 'NOSE_TOP'
GT.WS[ws].LN[1].PL[1].ammo_capacity = 8;
GT.WS[ws].LN[1].BR = 
	{
	{connector_name = 'Rocket_Point_01', drawArgument = 188},
	{connector_name = 'Rocket_Point_02', drawArgument = 189},
	{connector_name = 'Rocket_Point_03', drawArgument = 190},
	{connector_name = 'Rocket_Point_04', drawArgument = 191},
	{connector_name = 'Rocket_Point_05', drawArgument = 192},
	{connector_name = 'Rocket_Point_06', drawArgument = 193},
	{connector_name = 'Rocket_Point_07', drawArgument = 194},
	{connector_name = 'Rocket_Point_08', drawArgument = 195},
	}

---------------------------------------------------------------------------------------------------
--  Sistema russo missilistico anti aereo IGLA
---------------------------------------------------------------------------------------------------	

ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.SS_t.VYMPEL_TRACKER[1]);
GT.WS[ws].center = 'CENTER_RADAR_04'
GT.WS[ws].angles[1][1] = math.rad(140);
GT.WS[ws].angles[1][2] = math.rad(-140);
GT.WS[ws].drawArgument1 = 6
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.SS_t.VYMPEL_TRACKER[2]);
GT.WS[ws].base = ws-1;
local vympel_trackers = {{{"self", ws-1}}, {{"self", ws}}};


---- 9K38 Igla (Komar) di Prua
local ws = GT_t.inc_ws();
GT.WS[ws] = {};
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_OSA_M);
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.igla_manpad);
GT.WS[ws].center = "CENTER_TOWER_IGLA_01"
GT.WS[ws].angles[1][1] = math.rad(135);
GT.WS[ws].angles[1][2] = math.rad(-135);
GT.WS[ws].LN[1].show_external_missile = true;
GT.WS[ws].drawArgument1 = 59;
GT.WS[ws].drawArgument2 = 60;
GT.WS[ws].LN[1].BR = {
                        { connector_name = 'POINT_IGLA_1_1' },
                        { connector_name = 'POINT_IGLA_1_2' },
		     { connector_name = 'POINT_IGLA_1_3' },
		     { connector_name = 'POINT_IGLA_1_4' },			 
                    };	

---- 9K38 Igla (Komar) di Poppa
local ws = GT_t.inc_ws();
GT.WS[ws] = {};
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_OSA_M);
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.igla_manpad);
GT.WS[ws].center = "CENTER_TOWER_IGLA_02"
GT.WS[ws].angles = {
					{math.rad(180), math.rad(-180), math.rad(-5), math.rad(85)},
					};
GT.WS[ws].LN[1].show_external_missile = true;	
GT.WS[ws].drawArgument1 = 61;
GT.WS[ws].drawArgument2 = 62;
GT.WS[ws].stabilizer = true;
GT.WS[ws].reference_angle_Y = math.rad(0);
GT.WS[ws].reference_angle_Z = math.rad(30);

GT.WS[ws].LN[1].BR = {
             { connector_name = 'POINT_IGLA_2_1' },
             { connector_name = 'POINT_IGLA_2_2' },
	    { connector_name = 'POINT_IGLA_2_3' },
	    { connector_name = 'POINT_IGLA_2_4' },			 
                    };	

---------------------------------------------------------------------------------------------------
--  Parte Finale - Final Section
---------------------------------------------------------------------------------------------------

GT.Name = "Grad_Sviyazhsk_Corvette"
GT.DisplayName = _("Grad Sviyazhsk Corvette")
GT.Rate = 4000

GT.Sensors = {  OPTIC = {"long-range naval optics", "long-range naval LLTV", "long-range naval FLIR",},
                RADAR = {
                    "Patriot str",
                    "ticonderoga search radar",
                }
            };

GT.DetectionRange  = GT.airFindDist;
GT.ThreatRange = GT.airWeaponDist;
GT.Singleton   ="no";
GT.mapclasskey = "P0091000067";

GT.attribute = {wsType_Navy,wsType_Ship,wsType_ArmedShip,wsType_GenericLightArmoredShip,

                    "Cruisers",
                    "RADAR_BAND1_FOR_ARM",
                    "DetectionByAWACS",
				};
GT.Categories = {
					{name = "Armed Ship"}
				};
				
add_surface_unit(GT)				
